#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>

DIR *dirh;
FILE *fileh;
FILE *filelabels;
FILE *filedata;
unsigned char bunch[262144];
unsigned char tempsev[50000];
unsigned char character[8];
unsigned char *bigtable;
int *sumfilas;
int *sumcolumnas;
unsigned int *offsets;
unsigned int *grupos;
unsigned int *sizes;
int numchars=0;
int join,join_f,join_c,join_val;

int main(int argc, char *argv[])
	{
	struct dirent *dirp;
	char ext[5] = "";
	char noext[255]="";
	int nfram,i,j,k,l;
	if ((dirh = opendir(".")) == NULL)
		{
		printf("Error al abrir el directorio");
		exit(1);
		}
	if ((filelabels=fopen("labels.asm","wb"))==NULL)
		{
		printf("Error al crear labels.asm");
		exit(1);
		}	
	for (dirp = readdir(dirh); dirp != NULL; dirp = readdir(dirh))
		{
		if (strlen(dirp->d_name)>4)
			{
			strncpy(ext,dirp->d_name+strlen(dirp->d_name)-4,4);
			strncpy(noext,dirp->d_name,strlen(dirp->d_name)-4);
			noext[strlen(dirp->d_name)-4]='\0';
			char * tmp=ext;
			while (*tmp)
			     *tmp=toupper(*tmp++);
			if (strcmp(ext,".SEV")==0)
				{
				int P1,P2,SX,SY,C_SX,C_SY;
				int skip=0;
				printf("\nAbriendo %s\n",dirp->d_name);
                                if((fileh=fopen(dirp->d_name,"rb"))==NULL)
					{
					printf("Error al abrir el archivo\n");
					exit(1);
					};
				int nbytes=fread(tempsev,1,50000,fileh);
				printf("Leidos %u bytes\n",nbytes);
				printf("Cerrando %s\n",dirp->d_name);
				fclose(fileh);
                		if(tempsev[0]!='S'||tempsev[1]!='e'||tempsev[2]!='v'||tempsev[3]!='\0'||tempsev[4]!='\0')
	                        	{
					skip=1;
                        		}
				if(tempsev[5]==0)
					{
					P1=tempsev[6]+256*tempsev[7];
                                	P2=tempsev[8]+256*tempsev[9];
                                	SX=tempsev[10]+256*tempsev[11];
                                	SY=tempsev[12]+256*tempsev[13];
					if ((P1!=1)||(P2!=0)||(SX>256)||(SY>192))
	                                        {
						skip=1;
                                		}
					}
				else if (tempsev[5]==6||tempsev[5]==8)
					{
					P1=tempsev[6]+256*tempsev[7];
                                	P2=tempsev[8]+256*tempsev[9];
                                	SX=tempsev[10]+256*tempsev[11];
                                	SY=tempsev[12]+256*tempsev[13];					
                                	if ((P1>2)||(P2>31)||(SX>256)||(SY>192))
	                                        {
						skip=1;
                                		}
					}
				else	{
					skip=1;
					}
				if(skip==1)
					{
					printf("Invalid file, ignoring\n");
					}
				else	{
					fprintf(filelabels,"%s:\n\n",noext);
					C_SX=(SX/8)+(SX%8!=0);
					C_SY=(SY/8)+(SY%8!=0);
					printf("Version: 0.%u\n",tempsev[5]);
					if(P1==2)
						{
						printf("Mask will be ignored\n");
						}
					printf("Size: %u x %u pixels, %u x %u chars\n",SX,SY,C_SX,C_SY);
					printf("Frames: %u\n",P2+1);
					unsigned char *parser=&tempsev[14];
	                                for (nfram=0;nfram<(P2+1);nfram++)
                                        	{
						fprintf(filelabels,"\n; Frame: %u\n",nfram);
                                        	for (i=0;i<C_SX*C_SY;i++)
	                                                {
                                                	for (j=0;j<8;j++)
	                                                        {
                                                        	character[j]=*parser++;
                                                        	};
                                                	int attribute=*parser++;
							if (attribute==0)
								{
								// Ignorar caracter, sacar salida con:
								fprintf(filelabels,"DEFB 0\nDEFW 0\n");
								}
							else	{
								int nchar=insertchar();
								fprintf(filelabels,"DEFB %u\nDEFW CHAR%05u\n",attribute,nchar);
								}
                                                	};
                                        	if (P1==2)      // ignore mask
	                                                {
                                                	for (i=0;i<C_SX*C_SY;i++)
	                                                        {
                                                        	for (j=0;j<8;j++)
	                                                                {
                                                                	*parser++;
                                                                	};
                                                        	};
                                        	        }
						// To next frame we go...
                                        	}
					}
				}
			}
		}
	closedir(dirh);
	fclose(filelabels);
	if (numchars>0)
		{
		bigtable=(unsigned char *)malloc(numchars*numchars);
		sumfilas=(int *)malloc(numchars*sizeof(int));
		sumcolumnas=(int *)malloc(numchars*sizeof(int));
		offsets=(unsigned int *)malloc(numchars*sizeof(int));
		grupos=(unsigned int *)malloc(numchars*sizeof(int));
		sizes=(unsigned int *)malloc(numchars*sizeof(int));

		if ((bigtable==NULL)||(sumfilas==NULL)||(sumcolumnas==NULL)||(offsets==NULL)||(grupos==NULL)||(sizes==NULL))
			{
			printf("Error al reservar memoria para las tablas");
			exit(1);			
			}
		if ((filedata=fopen("data.asm","wb"))==NULL)
			{
			printf("Error al crear data.asm");
			exit(1);
			}
		printf("\nNumero total de caracteres: %u, ocupando %u bytes\n",numchars,numchars*8);
		// Generar gran tabla
		for (i=0;i<numchars;i++)
			{
			for(j=0;j<numchars;j++)
				{
				bigtable[i*numchars+j]=0; // Iniciar a 0
				if (i==j) continue;
				for(k=7;k>0;k--)
					{
					int coinc=0;
					for (l=0;l<(8-k);l++)
						{
						if (bunch[(8*i)+l]==bunch[(8*j)+k+l])
							{
							coinc++;
							}
						}
					if(coinc==(8-k))
						{
						bigtable[i*numchars+j]=8-k;
						}
					}
				}
			}
		for (i=0;i<numchars;i++)
			{
			sumcolumnas[i]=0;
			sumfilas[i]=0;
			offsets[i]=0;
			sizes[i]=8;
			grupos[i]=i;
			for(j=0;j<numchars;j++)
				{
				sumcolumnas[i]+=bigtable[j*numchars+i];
				sumfilas[i]+=bigtable[i*numchars+j];		
				}
			}

		while(1){
			join_f=-1;
			join_c=-1;
			join=numchars*numchars;
			join_val=0;
			for(j=0;j<numchars;j++)
				{
				if (sumfilas[j]<0)
					continue;
				for(k=0;k<numchars;k++)
					{
					if ((j==k)||(sumcolumnas[k]<0)||(grupos[j]==grupos[k]))
						continue;
					if (bigtable[j*numchars+k]>join_val)
						{
						if ((sizes[grupos[j]]+sizes[grupos[k]]-bigtable[j*numchars+k])<=256)
							{
							join=sumfilas[j]+sumcolumnas[k];
							join_f=j;
							join_c=k;
							join_val=bigtable[(j*numchars)+k];
							}
						}
					else if (bigtable[j*numchars+k]==join_val)
						{
						if (sumfilas[j]+sumcolumnas[k]<join)
							{
							if ((sizes[grupos[j]]+sizes[grupos[k]]-bigtable[j*numchars+k])<=256)
								{
								join=sumfilas[j]+sumcolumnas[k];
								join_f=j;
								join_c=k;
								join_val=bigtable[(j*numchars)+k];
								}
							}
						}
					}
				}
			if (join_val==0)
				{
				break;
				}
			// Unir dos filas
			int mirrorval=bigtable[(grupos[join_c]*numchars)+grupos[join_f]];
			sumfilas[join_c]-=mirrorval;
			sumcolumnas[join_f]-=mirrorval;
			for (j=0;j<numchars;j++)
				{
				if (sumfilas[j]>0)
					{
					sumfilas[j]=sumfilas[j]-bigtable[(numchars*j)+join_c];
					}
				if(sumcolumnas[j]>0)
					{
					sumcolumnas[j]=sumcolumnas[j]-bigtable[(join_f*numchars)+j];
					}
				}
			sumfilas[join_f]=-1;
			sumcolumnas[join_c]=-1;
			int size2=sizes[join_f];
			for (j=0;j<numchars;j++)
				{
				if(grupos[j]==join_f)
					{
					sizes[j]=0;
					offsets[j]=offsets[j]+sizes[grupos[join_c]]-join_val;
					grupos[j]=grupos[join_c];
					}
				}
			sizes[grupos[join_c]]=sizes[grupos[join_c]]+size2-join_val;
			}
		
		// Segunda ronda, uniones sin mezclar
		while(1){
			join_f=-1;
			join_c=-1;
			join=0;
			for(j=0;j<numchars;j++)
				{
				if (sumfilas[j]<0)
					continue;
				for(k=0;k<numchars;k++)
					{
					if ((sumcolumnas[k]<0)||(grupos[j]==grupos[k]))
						continue;
					if (sizes[grupos[j]]+sizes[grupos[k]]<=256)
						{
						if (sizes[grupos[j]]+sizes[grupos[k]]>join)
							{
							join=sizes[grupos[j]]+sizes[grupos[k]];
							join_f=j;
							join_c=k;
							}
						}
					}
				}
			if (join==0)
				{
				break; // Ya no hay uniones que den menos de 256 bytes
				}
			// Fusionar
			sumfilas[join_f]=-1;
			sumcolumnas[join_c]=-1;
			int size2=sizes[join_f];
			for (j=0;j<numchars;j++)
				{
				if(grupos[j]==join_f)
					{
					sizes[j]=0;
					offsets[j]=offsets[j]+sizes[grupos[join_c]];
					grupos[j]=grupos[join_c];
					}
				}
			sizes[grupos[join_c]]=sizes[grupos[join_c]]+size2;
			}

		// Salida:
		int ngrupos=0;
		int nbytes=0;
		for (i=0;i<numchars;i++)
			{
			int pointer=0;
			if (sizes[i]>0)
				{
				ngrupos++;
				nbytes+=sizes[i];
				fprintf(filedata,"\n;GRUPO %u: %u bytes\n",i,sizes[i]);
				for (j=0;j<sizes[i];j++)
					{
					for(k=0;k<numchars;k++)
						{
						if ((i==grupos[k])&&(offsets[k]==j))
							{
							fprintf(filedata,"CHAR%05u:\n",k);
							pointer=k*8;
							}
						}
					fprintf(filedata,"DEFB %u\n",bunch[pointer++]);
					}
				}
			}
		fclose(filedata);
		printf("\nNumero final de bytes: %u, en %u grupos\n",nbytes,ngrupos);
		}
	}

int insertchar()
	{
	int i,j;
	for(i=0;i<numchars;i++)
		{
		for (j=0;j<8;j++)
			{
			if (character[j]!=bunch[(8*i)+j])
				break;
			}
		if (j==8)
			{
			return i; // No insertar
			}
		}
	for (j=0;j<8;j++)
		{
		bunch[numchars*8+j]=character[j];
		}
	numchars++;
	return numchars-1;
	}
